/******************************************************************************
 CLibrary.c

				CLibrary Document Class
	

	Copyright (C) 1985-1992  New York University
	Copyright (C) 1994 George Washington University
	 
	This file is part of the GWAdaEd system, an extension of the Ada/Ed-C
	system.  See the Ada/Ed README file for warranty (none) and distribution
	info and also the GNU General Public License for more details.


	Generated by Classy (Object Factory) 8:29 PM Mon, Sep 27, 1993

	This file is only generated once. You can modify it by filling
	in the placeholder functions and adding any new functions you wish.



	This class is a subclass of the CSaver (and CDocument), but a lot
	of the default behavior has been disabled because this is a document
	that represents a directory (folder) as opposed to a file.

 ******************************************************************************/


#include "CLibrary.h"
#include "AppCommands.h"			// Remove comments if DoCommand overridden
#include "AdaConstants.h"
#include "AdaGlobals.h"

#include <CApplication.h>
#include <CBartender.h>
#include <CButtonProc.h>
#include <assert.h>
#include <string.h>
#include <Packages.h>

#include "CAdaApp.h"
#include "CUnits.h"
#include "SFGetFolder.h"
#include "FSUtilities.h"
#include "CFileMgr.h"
#include "FileNames.h"

extern	CApplication *gApplication;	/* The application */
extern	CBartender	*gBartender;	/* The menu handling object */

Boolean Bindable(UnitKind uk, MainKind mk);
Boolean Executable(UnitKind uk, MainKind mk);
void	RemoveSuffix(Str255 unit);


/**** C O N S T R U C T I O N / D E S T R U C T I O N   M E T H O D S ****/


/******************************************************************************
 ICLibrary

	Initialize the document

	IMPORTANT NOTE: When an object is initialized as part of a
	'CVue' resource, this I-function is NEVER CALLED. Instead,
	the object is initialized in its GetFrom method(s). To add your
	own initialization, override GetFrom.

 ******************************************************************************/

void CLibrary::ICLibrary(FSSpec spec)
{
	FSSpec		currDoc;
	Str255		fullName;
	Boolean		newLib;
	MenuHandle	menu;
	OSErr		err;


	Ix_CLibrary();

		// Initialize data members here

	lib.unit_count = 0;
	libSpec = spec;
	GetFullPath(spec, &libPath);
	initLibrary = false;
	libFileFound = false;
	libAllocated = false;

	CopyPString(libPath, fullName);
	ConcatPStrings(fullName, "\pLib");	// default lib name

	// Check if the library already exists or if it is new.
	err = FSMakeFSSpec(0, 0, fullName, &currDoc);
	libFileFound = (err == noErr);
	if (!libFileFound)
		initLibrary = true;

}

/******************************************************************************
 ForceClassReferences

	Does nothing, just here to make a smart linker work stupidly.
	Sometimes software is too smart for its own good.
 ******************************************************************************/

void CLibrary::ForceClassReferences( void)
{
		// example of referencing classes used only with new_by_name
	Boolean alwaysFalse = FALSE;
	CObject *dummy;
	
	if (alwaysFalse)
	{
		member( dummy, CUnits);
	}
}

/******************************************************************************
 Dispose {OVERRIDE}

		Dispose of a Document
 ******************************************************************************/

void CLibrary::Dispose(void)

{
	// release lib
	libFileFound = false;
	initLibrary = false;
	if (libAllocated)
		freeadalib(lib);
	libAllocated = false;

	inherited::Dispose();
}

/******************************************************************************
 NewLibrary

	Create a New Library
 ******************************************************************************/

void	CLibrary::NewLibrary(void)
{
	CAdaApp *app = (CAdaApp *)gApplication;
	Str255			theName;

	libFileFound = false;
	initLibrary = true;
	libAllocated = false;

   	Clean();						/* Not dirty any longer				*/

	if (itsWindow == NULL)			/* If window wasn't created by		*/
		MakeNewWindow();			/*	 ReadContents, make it now		*/
	ContentsToWindow();				/* Make contents displayable		*/

	PositionWindow();				/* Must be done before making name	*/
	itsWindow->SetTitle(libPath);
	itsWindow->Select();			/* Activate the window				*/
}

/******************************************************************************
 OpenLibrary

	Open an existing Library
 ******************************************************************************/

void	CLibrary::OpenLibrary(void)
{
	CAdaApp *app = (CAdaApp *)gApplication;
	Str255			theName;

	ReadLibrary();

   	Clean();						/* Not dirty any longer				*/

	if (itsWindow == NULL)			/* If window wasn't created by		*/
		MakeNewWindow();			/*	 ReadContents, make it now		*/
	ContentsToWindow();				/* Make contents displayable		*/

	PositionWindow();				/* Must be done before making name	*/

	itsWindow->SetTitle(libPath);
	itsWindow->Select();			/* Activate the window				*/
}

/******************************************************************************
 Close
 ******************************************************************************/

Boolean	CLibrary::Close(Boolean quitting)
{
	CAdaApp *app = (CAdaApp *)gApplication;
	
	if (inherited::Close(quitting)) {

		app->LibraryClosed();
	}
}

/******************************************************************************
 ReadLibrary

	Read a document from the file that the application has selected
	as the user library and display its contents.
 ******************************************************************************/

void	CLibrary::ReadLibrary(void)
{
	CAdaApp *app = (CAdaApp *)gApplication;
	int err;
	Library data;


	// read in library here (only if the library file was there)
	if (libFileFound) {
		PtoCstr(libPath);
		err = adalib((char *)libPath, &data);
		CtoPstr((char *)libPath);

		lib = data;

		if (err == noErr) {
			initLibrary = false;
			libAllocated = true;
	
			// if the library file was not found, then we do have a
			// library, but tell the application that we must initialize
			// it the next time we compile something.
		}
		else if (err == fnfErr) {
			libFileFound = false;
			initLibrary = true;
			libAllocated = false;		// there was an error
			
			lib.unit_count = 0;			// just to be on the save side
		}
	}
}

/******************************************************************************
 WriteOptions

	Write the command options to the options file for this library.  Only the
	library knows if it is new or not.
******************************************************************************/

void	CLibrary::WriteOptions(FILE *fp)
{
	if (initLibrary)
		fprintf(fp, "-nl\n");
	else
		fprintf(fp, "-l\n");
	fprintf(fp, "%#s\n", libPath);
}

/******************************************************************************
 ContentsToWindow
 
 	Make window reflect document's contents.  If the document does
 	not use a file, this function is never called and may be deleted.
******************************************************************************/

void CLibrary::ContentsToWindow()
{
	// Transfer data from library to window by creating number of rows
	// in the data structure

	if (libFileFound) {
		// Create number of lines in the top pane (CUnits)
		fLibrary_Units->SetLibUnits(lib.unit_count, lib.units);
	}
	else
		fLibrary_Units->SetLibUnits(0, NULL);

	// As a default, turn off selection of lines in the table, 
	// so we should deactivate the buttons here...
	fLibrary_Units->DeselectAll(false);
	fLibrary_Bind->Deactivate();
	fLibrary_Execute->Deactivate();
}

/******************************************************************************
 LibraryChanged (the contents, that is)

	Call this method to read in new contents of the library
	from disk.  This method will read in the new contents and
	if everything is ok, then it will destroy the old contents.
 ******************************************************************************/
void	CLibrary::LibraryChanged(void)
{
	int err;
	Library data;
	CAdaApp *app = (CAdaApp *)gApplication;


	// read in library here again
	PtoCstr(libPath);
	err = adalib((char *)libPath, &data);
	CtoPstr((char *)libPath);

	if (err == noErr) {

		if (libAllocated)
			freeadalib(lib);
		lib = data;

		libFileFound = true;
		initLibrary = false;
		libAllocated = true;

		UpdateContents();
	}

	// This is an error, what should we do?
	else if (err == fnfErr) {
		libFileFound = true;
		initLibrary = true;
		// don't change 'libAllocated'

		StopAlert(20040, NULL);
	}
}

/******************************************************************************
 UpdateContents

	Call this to update the contents of the window when the library
	has changed.  This method adds/removes lines from the table
	pane to accomodate for new entries.
	
	The window is refreshed.
 ******************************************************************************/
void	CLibrary::UpdateContents(void)
{
	GrafPtr		thePort;

	ContentsToWindow();

	thePort = itsWindow->GetMacPort();
	InvalRect(&thePort->portRect);	/* Force an update */
}

/******************************************************************************
 BuildMenu
 ******************************************************************************/
void	CLibrary::BuildMenu(MenuHandle menu, Boolean bind)
{
	short count, i;
	Cell theCell;
	Str255 unit;
	UnitKind uk;
	MainKind mk;
	short menuId;
	short menuItem;
	long cmdNo;
	short afterBind, afterExec;


	menuId = bind ? kBindOtherMenu : kExecuteOtherMenu;
	menuItem = 1;

	// Delete all menu items
	count = CountMItems(menu);
	cmdNo = (-(((long)menuId) << 16) - menuItem);
	for (i = 0; i < count; i++)
		gBartender->RemoveMenuCmd(cmdNo);


	// Add all items in the library table that can be binded
	// or executed, depending on argument 'bind'

	count = fLibrary_Units->GetRowCount();
	theCell.h = 0;
	afterBind = 0;
	afterExec = 0;
	for (theCell.v = 0; theCell.v < count; theCell.v++) {
		if (fLibrary_Units->GetUnit(theCell, &uk, &mk, unit)) {
			if (bind && Bindable(uk, mk)) {
				cmdNo = (-(((long)kBindOtherMenu) << 16) - ++afterBind);
				gBartender->InsertMenuCmd(cmdNo, unit, kBindOtherMenu, afterBind-1);
			}
			else if (!bind && Executable(uk, mk)) {
				// Executable units (kBindingUnit) have a name
				// appended at the end (_idle_task).  Remove it
				// form the name for the menu.
				RemoveSuffix(unit);
				cmdNo = (-(((long)kExecuteOtherMenu) << 16) - ++afterExec);
				gBartender->InsertMenuCmd(cmdNo, unit, kExecuteOtherMenu, afterExec-1);
			}
		}
	}
}

/******************************************************************************
 HasContents

	Return true if this library has a 'lib' file in its directory,
	if that file contains units, and if we haven't tagged the lib
	to be reinitialized.

 ******************************************************************************/
Boolean	CLibrary::HasContents(void)
{
	return libFileFound && (lib.unit_count > 0) && (!initLibrary);
}

/******************************************************************************
 BuildBindMenu
 ******************************************************************************/
void	CLibrary::GetFullName(Str255 fullName)
{
	CopyPString(libPath, fullName);
}

/******************************************************************************
 BuildBindMenu
 ******************************************************************************/
void	CLibrary::BuildBindMenu(MenuHandle menu)
{
	BuildMenu(menu, true);
}

/******************************************************************************
 BuildExecuteMenu
 ******************************************************************************/
void	CLibrary::BuildExecuteMenu(MenuHandle menu)
{
	BuildMenu(menu, false);
}

/******************************************************************************
 UdpateMenus
 ******************************************************************************/

void	CLibrary::UpdateMenus(void)
{
	Cell theCell;
	Str255 unit;
	UnitKind uk;
	MainKind mk;

	inherited::UpdateMenus();

	if (HasContents()) {
		gBartender->EnableCmd(cmdInitializeLibrary);

		gBartender->EnableMenu(kBindOtherMenu);
		gBartender->EnableMenu(kExecuteOtherMenu);
	}
	else {
		gBartender->DisableCmd(cmdInitializeLibrary);

		// Also, if the library has nothing inside, then
		// disable the Bind/Execute hierarchicaly menu
		
		gBartender->DisableMenu(kBindOtherMenu);
		gBartender->DisableMenu(kExecuteOtherMenu);
	}

	gBartender->EnableCmd(cmdCloseUserLibrary);
	gBartender->DisableCmd(cmdNewUserLibrary);
	gBartender->DisableCmd(cmdOpenLibrary);

	// Get next one that is selected
	if (fLibrary_Units->GetSelectedUnit(&theCell, &uk, &mk, unit)) {
		Str255 cmd;

		if (Bindable(uk, mk)) {
			CopyPString("\pBind ", cmd);
			ConcatPStrings(cmd, unit);
			gBartender->SetCmdText(cmdBindOne, cmd);
			gBartender->EnableCmd(cmdBindOne);
		}
		else {
			gBartender->SetCmdText(cmdBindOne, "\pBind");
			gBartender->DisableCmd(cmdBindOne);
		}

		if (Executable(uk, mk)) {
			RemoveSuffix(unit);
			CopyPString("\pExecute ", cmd);
			ConcatPStrings(cmd, unit);
			gBartender->SetCmdText(cmdExecuteOne, cmd);
			gBartender->EnableCmd(cmdExecuteOne);
		}
		else {
			gBartender->SetCmdText(cmdExecuteOne, "\pExecute");
			gBartender->DisableCmd(cmdExecuteOne);
		}

	}

	else {
		gBartender->SetCmdText(cmdBindOne, "\pBind");
		gBartender->DisableCmd(cmdBindOne);

		gBartender->SetCmdText(cmdExecuteOne, "\pExecute");
		gBartender->DisableCmd(cmdExecuteOne);
	}



	/* The library document can't print anything */
	gBartender->DisableCmd(cmdPageSetup);
	gBartender->DisableCmd(cmdPrint);


}


/******************************************************************************
 DoCommand
 ******************************************************************************/
void	CLibrary::DoCommand(long theCommand)
{
CAdaApp *app = (CAdaApp *)gApplication;

	switch (theCommand) {
		case cmdCloseUserLibrary:		// Change this to a cmdClose
			inherited::DoCommand(cmdClose);
			break;

		case cmdInitializeLibrary: {	// initialize the library
			short id;

			id = StopAlert(20030, NULL);
			if (id == 1)			// 1 == ok
				DoCmdInitializeLibrary();
			break;
		}

		case cmdBindOne: {
			Cell theCell;
			Str255 unit;
			UnitKind uk;
			MainKind mk;
			
			// Get next one that is selected
			if (fLibrary_Units->GetSelectedUnit(&theCell, &uk, &mk, unit)) {
				assert(Bindable(uk, mk));
				app->Bind(unit);
			}
			break;
		}

		case cmdExecuteOne: {
			Cell theCell;
			Str255 unit;
			UnitKind uk;
			MainKind mk;
			
			// Get next one that is selected
			if (fLibrary_Units->GetSelectedUnit(&theCell, &uk, &mk, unit)) {
				assert(Executable(uk, mk));
				RemoveSuffix(unit);
				app->Execute(unit);
			}
		}
		break;

		default:
			inherited::DoCommand(theCommand);
			break;
	}
}

/******************************************************************************
 DoCmdInitializeLibrary
 ******************************************************************************/
void	CLibrary::DoCmdInitializeLibrary(void)
{
	FSSpec	folder;
	FSSpec	file;
	long	item;
	long	count;
	
	// delete all rows in the units display, and
	// mark this as not having a lib file.

	initLibrary = true;		// this will force an init
	fLibrary_Units->DeselectAll(false);
	fLibrary_Units->SetLibUnits(0, lib.units);

	// delete all files in the file directory
	folder = gFileMgr->GetLibraryFolder();

	count = CountItemsInFolder(folder);
	for (item = 1; item <= count; item++) {

		GetItemInFolder(item, folder, &file);
		if (!ItemIsFolder(file)) {
			Str255 result;

			// check against the default file extensions that
			// NYU creates... (.trc, .aic, .axq)
			// and the file "lib"

			ParseFile(file.name, flExtension, result);
			Lowercase(result);
			if ((IUEqualString(result, "\p.trc") == 0) ||
				(IUEqualString(result, "\p.aic") == 0) ||
				(IUEqualString(result, "\p.axq") == 0) ||
				(IUEqualString(file.name, "\plib") == 0)) {

				// ignore errors returned
				FSpDelete(&file);
				count--;
				item--;		/* we just deleted item 'i', the next
							 * item to delete is item 'i', all files
							 * get bumped up one position in the folder.
							 */
			}
		}
	}
}

/******************************************************************************
 ProviderChanged
 ******************************************************************************/
void CLibrary::ProviderChanged( CCollaborator *aProvider, long reason, void* info)

{

	if ((reason == tableSelectionChanged) &&
		(aProvider == fLibrary_Units)) {
		Cell theCell;
		Str255 unit;
		UnitKind uk;
		MainKind mk;
		
		// Get next one that is selected
		if (fLibrary_Units->GetSelectedUnit(&theCell, &uk, &mk, unit)) {
			Boolean dblClickAction;

			dblClickAction = false;

			// if selection is of right type then
			if (Bindable(uk, mk)) {
				dblClickAction = true;
				fLibrary_Units->SetDblClickCmd(cmdBindOne);
				fLibrary_Bind->Activate();
			}
			else
				fLibrary_Bind->Deactivate();

			if (Executable(uk, mk)) {
				dblClickAction = true;
				fLibrary_Units->SetDblClickCmd(cmdExecuteOne);
				fLibrary_Execute->Activate();
			}
			else
				fLibrary_Execute->Deactivate();

			// If we don't have any double click action, then set the double
			// click command to cmdNULL.
			if (!dblClickAction)
				fLibrary_Units->SetDblClickCmd(cmdNull);

		}
		else {
			fLibrary_Bind->Deactivate();
			fLibrary_Execute->Deactivate();
		}
	}
	else
		inherited::ProviderChanged(aProvider, reason, info);

}	/* CLibrary::ProviderChanged */


/******************************************************************************
 Bindable
 ******************************************************************************/
Boolean Bindable(UnitKind uk, MainKind mk)
{
	return ((uk == kSubprogram) && (mk == kMain));
}

/******************************************************************************
 Executable
 ******************************************************************************/
Boolean Executable(UnitKind uk, MainKind mk)
{
	return (uk == kBindingUnit);
}

/******************************************************************************
 RemoveSuffix
 ******************************************************************************/
#define kRemoveSuffix "_idle_task"
void	RemoveSuffix(Str255 unit)
{
	short len = strlen(kRemoveSuffix);
	short suffixStart = unit[0] - len;
	
	if ((unit[0] > len) &&
		(strncmp(kRemoveSuffix, (char *)&unit[suffixStart+1], len) == 0))
		unit[0] -= len;
}

